define([
		'app',
		'authentication_service',
		'connection_error_service',
		'connection_timeout_service',
		'modalService',
		'NotificationsPreferencesService',
		'SplashController',
		'HeaderController',
		'FooterController',
		'MainController',
		'HelpController',
		'AboutController',
		'highcharts-ng',
	 	'CalendarDatePicker',
		'InputCalendarDatePicker',
		'SecondaryNavigationController',
		'HomeModule',
		'LearnMoreModule',
		'TrackersModule',
		'FitnessModule',
		'NotificationsModule',
        'SupportModule',
		'userService'
	],
	function (app) {
		"use strict";

		app.config(function ($stateProvider, unsavedWarningsConfigProvider) {

			$stateProvider
				.state('main', {
					abstract: true,
					data: {
						moduleName: "VA FitHeart",
						requiresAuth: true
					},
					views: {
						"": {
							templateUrl: 'src/container/main/main_template.html',
							controller: 'MainController'
						},
						'header@main': {
							templateUrl: 'src/container/components/header/header_template.html',
							controller: 'HeaderController'
						},
						'footer@main': {
							templateUrl: 'src/container/components/footer/footer_template.html',
							controller: 'FooterController'
						}
					}
				})
				.state('main.auth', {
					abstract: true,
					resolve: {
						auth: function ($q, pageService, authenticationService, NotificationsPreferencesService, userService) {
							var defer = $q.defer();
							var port = window.location.port;

							authenticationService.checkAuthStatus().then(function (response) {
								var isAuthenticated = response;
								if (isAuthenticated) {
									userService.getUserData().then(function (response) {
										if (NotificationsPreferencesService.isPreferenceStored() === false) {
											defer.reject({
												error: 'initial-settings'
											});
										} else if (NotificationsPreferencesService.isPreferenceStored() === null) {
											return NotificationsPreferencesService.getNotificationsPreference().then(
												function () {
													defer.resolve();
												},
												function (error) {
													defer.reject({
														error: 'initial-settings'
													});
												}
											);
										} else {
											defer.resolve();
										}
									});
								} else {
									defer.reject({
										error: 'auth'
									});
								}
							}, function (error) {
								defer.reject({error: 'auth'});
							});

							return defer.promise;
						}
					}
				})
				.state('main.auth.two-panel', {
					abstract: true,
					views: {
						'@main': {
							templateUrl: 'src/container/components/content/two-column_template.html',
							controller: 'TwoPanelController'
						}						
					}
				})
				.state('main.auth.two-panel.secondary-navigation', {
					abstract: true,
					views : {
						'secondary@main.auth.two-panel' : {
							templateUrl: "src/container/components/content/secondary-navigation/secondary-navigation_template.html",
							controller: "SecondaryNavigationController"
						}
					}
				})
				.state('main.splash', {
					url: '/login',
					data : {
						requiresAuth: false
					},
					templateUrl: 'src/container/splash/splash_template.html',
					controller: 'SplashController',
					module: 'preventNavigation'
				})
				.state('nonStateRedirect', {
					url: '/redirecting'
				});

			unsavedWarningsConfigProvider.useTranslateService = false;
		});

		app.run(function ($rootScope, $state, $window, pageService, connectionErrorService, authenticationService) {

			connectionErrorService.run();

			$rootScope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
				if (toState.data.requiresAuth) {
					authenticationService.checkAuthStatus().then(function (response) {
						var isAuthenticated = response;
						if (isAuthenticated == false) {
							$state.go('main.splash');
						}
					});
				}
			});

			$rootScope.$on('$stateChangeError', function (event, toState, toParams, fromState, fromParams, error) {

				if (error.redirect) {
					$state.go('nonStateRedirect');
					$window.open(error.redirect, '_self', null, true);
				} else {
					switch (error.error) {
						case 'auth': 
							$state.go('main.splash');
							break;
						case 'initial-settings': 
							$state.go('main.initial-settings');
							break;
						default:
							console.error('$stateChangeError:', error);
							break;
					}
				}

			});
		});
	});